package complex_operations;

import db_context.DbContext;
import db_context.MyExceptions;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Refund {
    private static final Refund INSTANCE = new Refund();
    public static Refund getInstance() {
        return INSTANCE;
    }
    private Refund() {
    }

    public void DoRefund() throws SQLException {
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_REPEATABLE_READ);
        DbContext.getConnection().setAutoCommit(false);
        try {
            SQLLock();
            SQLSelect();
            SQLUpdate();
            DbContext.getConnection().commit();
            System.out.println("All damaged packages was refunded");
        }catch(Exception e){
            System.out.println(e.getMessage());
            DbContext.getConnection().rollback();
        }finally {
            DbContext.getConnection().setAutoCommit(true);
        }
    }

    public void SQLLock() throws SQLException {
        try(PreparedStatement s = DbContext.getConnection().prepareStatement("lock packages in exclusive mode")){
            s.execute();
        }
    }

    public void SQLSelect() throws SQLException, MyExceptions.NotSuchIdException {
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(select_string)){
            try(ResultSet r = s.executeQuery()){
                while (r.next()){
                    if(r.getBoolean(2)){
                        System.out.print(OtherOperations.getInstance().findCustomerName(r.getInt(3)));
                        System.out.print(" received ");
                        System.out.print(r.getString(5) + "€");
                        System.out.println(" as a refund for damaged package with id: " + r.getInt(1));
                    }else{
                        System.out.print(OtherOperations.getInstance().findCustomerName(r.getInt(3)));
                        System.out.print(" received ");
                        System.out.print(r.getString(4) + "€");
                        System.out.println(" as a refund for damaged package with id: " + r.getInt(1));
                    }
                }
            }
        }
    }

    public void SQLUpdate() throws SQLException {
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(update_string)){
            s.executeUpdate();
        }
    }

    String select_string = "" +
            "select\n" +
            "    id, insurance, sender_id,\n" +
            "    (select sum((1/100.0) * uninsured_ratio * price) from items where p.id = package_id) as uninsured,\n" +
            "    (select sum(price) from items where p.id = package_id) as insured\n" +
            "from packages p where damage > 0 and (status = 'damaged' or status = 'delivered')";

    String update_string = "" +
            "update packages set status = 'refunded' \n" +
            "where damage > 0 and (status = 'damaged' or status = 'delivered')";

}
